
function c_ini = pop2cini(popolazione,mu,altitudine,V_mod,distanza,vel_unit)

    DV = popolazione(:,1);                                                  % Colonna dv random tra [0-2]
    theta = popolazione(:,2);                                               % Colonna theta random tra [220,320]
    phi = zeros(length(popolazione),1);                                     % Colonna phi random tra [-5,5]
    tf = popolazione(:,3);                                                  % Colonna tf random tra [pi,40pi]

    % Definizione del dv nelle sue 3 componenti

    DV_x = DV.*cosd(theta+90).*cosd(phi);                                   % DV nelle tre direzioni dimensionali [km/s]
    DV_y = DV.*sind(theta+90).*cosd(phi);
    DV_z = DV.*sind(phi);

    % Definizione condizioni iniziali dimensionali

    x_0 = altitudine.*cosd(theta).*cosd(phi);                               % Posizioni iniziali dimensionali [Km]
    y_0 = altitudine.*sind(theta).*cosd(phi);
    z_0 = altitudine.*sind(phi);
    
    vx_0 = V_mod.*cosd(theta+90).*cosd(phi);                                % Velocità iniziali dimensionali [Km/s]
    vy_0 = V_mod.*sind(theta+90).*cosd(phi); 
    vz_0 = V_mod.*sind(phi);

    % Definizione condizioni iniziali adimensionali

    csi_0 = x_0./distanza - mu;                                             % Posizioni iniziali adimensionali
    eta_0 = y_0./distanza;
    zi_0 = z_0./distanza;

    v_csi_0 = vx_0./vel_unit;                                               % Velocità iniziali adimensionali
    v_eta_0 = vy_0./vel_unit;  
    v_zi_0 = vz_0./vel_unit;

    dv_x = DV_x./vel_unit;                                                  % Dv nelle tre direzioni adimensionali
    dv_y = DV_y./vel_unit;                                                  
    dv_z = DV_z./vel_unit;

    c_ini= [csi_0 eta_0 zi_0 v_csi_0 v_eta_0 v_zi_0];                       % Vettore condizioni iniziali adimensionali + DV adimensionale
    c_ini(:,4:6) = c_ini(:,4:6) + [dv_x, dv_y, dv_z];

end
